<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\Contest;
use App\Models\Level;
use App\Models\Common;
use App\Models\Daily_Quiz_Question;
use App\Models\Transaction;
use App\Models\Audio_Quiz_Question;
use App\Models\Avatar;
use App\Models\Battles_Question;
use App\Models\Classification;
use App\Models\Exam;
use App\Models\Fear_Factor_Quiz_Question;
use App\Models\Group_Battles;
use App\Models\Normal_Quiz_Question;
use App\Models\One_vs_One_Battles;
use App\Models\Package;
use App\Models\Pratice_Quiz_Question;
use App\Models\Product;
use App\Models\Skill;
use App\Models\True_False_Quiz_Question;
use App\Models\Ultimate_Challenge;
use App\Models\User;
use App\Models\Video_Quiz_Question;
use App\Models\Withdrawal_Request;
use Exception;

class DashboardController extends Controller
{
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index()
    {
        try {
            // Counter Card
            $params['total_user'] = User::count();
            $params['total_category'] = Category::count();
            $params['total_skill'] = Skill::count();
            $params['total_classification'] = Classification::count();
            $params['total_level'] = Level::count();
            $params['total_avatar'] = Avatar::count();
            $params['total_pratice_question'] = Pratice_Quiz_Question::count();
            $params['total_normal_question'] = Normal_Quiz_Question::count();
            $params['total_audio_question'] = Audio_Quiz_Question::count();
            $params['total_video_question'] = Video_Quiz_Question::count();
            $params['total_true_false_question'] = True_False_Quiz_Question::count();
            $params['total_daily_quiz_question'] = Daily_Quiz_Question::count();
            $params['total_fear_factor_question'] = Fear_Factor_Quiz_Question::count();
            $params['total_ultimate_challenges'] = Ultimate_Challenge::count();
            $params['total_contests'] = Contest::count();
            $params['total_exams'] = Exam::count();
            $params['total_battles_question'] = Battles_Question::count();
            $params['total_1_vs_1_battles'] = One_vs_One_Battles::count();
            $params['total_group_battles'] = Group_Battles::count();
            $params['total_package'] = Package::count();
            $params['total_product'] = Product::count();

            // User Statistice
            $user_data = [];
            $user_month = [];
            $d = cal_days_in_month(CAL_GREGORIAN, date('m'), date('Y'));
            for ($i = 1; $i < 13; $i++) {
                $Sum = User::whereYear('created_at', date('Y'))->whereMonth('created_at', $i)->count();
                $user_data['sum'][] = (int) $Sum;
            }
            for ($i = 1; $i <= $d; $i++) {
                $Sum = User::whereYear('created_at', date('Y'))->whereMonth('created_at', date('m'))->whereDay('created_at', $i)->count();
                $user_month['sum'][] = (int) $Sum;
            }
            $params['user_year'] = json_encode($user_data);
            $params['user_month'] = json_encode($user_month);

            // Counter Card
            $params['total_current_month'] = Transaction::whereMonth('created_at', date('m'))->whereYear('created_at', date('Y'))->sum('price');
            $params['total_year'] = Transaction::whereYear('created_at', date('Y'))->sum('price');
            $params['total_request_pending'] = Withdrawal_Request::where('status', 0)->sum('total_amount');
            $params['total_request_completed'] = Withdrawal_Request::where('status', 1)->sum('total_amount');

            // Package Statistice
            $subscription = Package::get();
            $pack_data = [];
            foreach ($subscription as $row) {

                $sum = array();
                for ($i = 1; $i < 13; $i++) {
                    $Sum = Transaction::where('package_id', $row['id'])->whereYear('created_at', date('Y'))->whereMonth('created_at', $i)->sum('price');
                    $sum[] = (int) $Sum;
                }
                $pack_data['label'][] = $row['name'];
                $pack_data['sum'][] = $sum;
            }
            $params['package'] = json_encode($pack_data);

            // Withdrawal Statistice
            $withdrawal_data['sum'][0] = (int) Withdrawal_Request::whereYear('created_at', date('Y'))->where('status', 0)->sum('total_amount');
            $withdrawal_data['sum'][1] = (int) Withdrawal_Request::whereYear('created_at', date('Y'))->where('status', 1)->sum('total_amount');
            $params['withdrawal_earning'] = json_encode($withdrawal_data);

            return view('admin.dashboard.dashboard', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
